/*:
 * @target MZ
 * @plugindesc 武器・防具をアイテムメニューから使用可能にし、コモンイベントを呼び出す
 * @author Grok
 * @help
 * ■使い方
 * 武器/防具のメモ欄に <CommonEvent: 5> のように記述すると、
 * そのIDのコモンイベントが使用時に実行されます。
 *
 * メモ欄に何も書かなかった場合はグレーアウト（使用不可）になります。
 * 武器・防具は「武器」「防具」タブにのみ表示されます。
 * 「アイテム」「大事なもの」タブには表示されません。
 */

(function() {

    // アイテムリストに含めるかを判定（カテゴリを尊重する）
    const _Window_ItemList_includes = Window_ItemList.prototype.includes;
    Window_ItemList.prototype.includes = function(item) {
        // 通常のアイテム・キーアイテムはデフォルトの判定に任せる
        if (DataManager.isItem(item)) {
            return _Window_ItemList_includes.call(this, item);
        }

        // 武器・防具の場合
        if (DataManager.isWeapon(item) || DataManager.isArmor(item)) {
            // 現在のカテゴリが :weapon または :armor の場合のみ表示
            if (this._category === "weapon" || this._category === "armor") {
                return true;
            }
            return false;  // 他のカテゴリ（item / keyItem）では表示しない
        }

        return _Window_ItemList_includes.call(this, item);
    };

    // 使用可能にする（武器・防具はメモ欄の有無で判断）
    const _Window_ItemList_isEnabled = Window_ItemList.prototype.isEnabled;
    Window_ItemList.prototype.isEnabled = function(item) {
        if (DataManager.isWeapon(item) || DataManager.isArmor(item)) {
            return !!item.meta.CommonEvent;  // メモ欄がないとグレーアウト
        }
        return _Window_ItemList_isEnabled.call(this, item);
    };

    // 使用時の処理
    const _Scene_ItemBase_useItem = Scene_ItemBase.prototype.useItem;
    Scene_ItemBase.prototype.useItem = function() {
        const item = this.item();
        if (DataManager.isWeapon(item) || DataManager.isArmor(item)) {
            const commonEventId = Number(item.meta.CommonEvent || 0);
            if (commonEventId > 0) {
                $gameTemp.reserveCommonEvent(commonEventId);
                SoundManager.playUseItem();
                this.activateItemWindow();
                return;
            } else {
                SoundManager.playBuzzer();
                this.activateItemWindow();
                return;
            }
        }
        _Scene_ItemBase_useItem.call(this);
    };

})();